'SubCommand1.bas
'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Article 1
'Created by Richard Ryles April 2003
'I've already added the goodsub and mine sprites onto the background.
'You are to add the rest of the sprites on the screen.
'The other bitmaps are as follows.
'enemysub.bmp
'ship.bmp
'torpedo.bmp

'I've left off many of the comments made in the 2ndWindow.bas so if you
'need more explaination of what is going on then take a look at it.

'I'll give you my solution in the next issue.

'I.  Window Setup
nomainwin
WindowWidth = 500:WindowHeight =320
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)

graphicbox #game.g, 0, 20, 500, 300
statictext #game.st, "You can put a score here",0,0,200,18 'adding the statictext along the top

'*** Open your window, put your title where it says "1st Game Window"
open "2nd Game Window" for window as #game  'here we are opening a basic window
print #game, "trapclose [quit]"

'II.  Load Bitmaps
loadbmp "bg", "subBG.bmp"       'loading the bitmaps we will use into memory
loadbmp "sub", "goodsub.bmp"
loadbmp "mine", "mine.bmp"

'III.  Initialize Variables

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "background bg";     'Now we set the bitmap "bg" that we loaded earlier as
                                                  'the background for our graphic box.

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite sub sub"          'add the sprites to the graphicbox
print #game.g, "addsprite mine mine"

    'C.  Set Initial Location of Sprites - spritexy
print #game.g, "spritexy sub 20 75"         'set the beginning locations of the sprites
print #game.g, "spritexy mine 250 200"

   ' D.  Set other Sprite Attributes


'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]
wait

'VI.  Initialize Keyboard and Mouse Events

'VII.  Timer Branch
[TimerBranch]
gosub [draw]
wait

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
    unloadbmp "bg"          'unloads the bitmaps to free up memory
    unloadbmp "sub"
    unloadbmp "mine"
    close #game
    end

'IX.  Branches called by Mouse and or Keyboard - user entity movement

'X.  Subs Called by Timer Branch
[draw]
print #game.g, "drawsprites";
return
